using System;
using System.Collections.Generic;

namespace IComparable
{
	// Prosta klasa przechowywana w tablicy 
	public class Employee : IComparable<Employee>
	{
		private int empID;

		public Employee(int empID)
		{
			this.empID = empID;
		}

		public override string ToString()
		{
			return empID.ToString();
		}


		public bool Equals(Employee other)
		{
			if (this.empID == other.empID)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		// Mechanizm porwnywania deleguje porwnywanie z powrotem do klasy Employee.
		// Klasa Employee uywa domylnej metody
		// CompareTo dla liczb cakowitych

		public int CompareTo(Employee rhs)
		{
			return this.empID.CompareTo(rhs.empID);
		}
	}

	public class Tester
	{
		static void Main()
		{
			List<Employee> empList = new List<Employee>();
			List<Int32> intList = new List<Int32>();

			// Generowanie liczby losowe zarwno
			// dla liczb cakowitych, jak i 
			// dla identyfikatorw pracownikw
			Random r = new Random();

			// Zapenianie tablicy 
			for (int i = 0; i < 5; i++)
			{
				// Dodawanie losowego identyfikatora pracownika
				empList.Add(new Employee(r.Next(10) + 100));

				// Dodawanie losowej liczby cakowitej
				intList.Add(r.Next(10));
			}


			// Wywietlanie caej zawartoci tablicy liczb cakowitych
			Console.WriteLine("List<int> przed sortowaniem:");
			for (int i = 0; i < intList.Count; i++)
			{
				Console.Write("{0} ", intList[i].ToString());
			}
			Console.WriteLine("\n");

			// Wywietlanie caej zawartoci tablicy obiektw klasy Employee
			Console.WriteLine("List<Employee> przed sortowaniem:");
			for (int i = 0; i < empList.Count; i++)
			{
				Console.Write("{0} ", empList[i].ToString());
			}
			Console.WriteLine("\n");

			// Sortowanie i wywietlanie elementw tablicy liczb cakowitych 
			Console.WriteLine("List<int> po sortowaniu:");
			intList.Sort();
			for (int i = 0; i < intList.Count; i++)
			{
				Console.Write("{0} ", intList[i].ToString());
			}
			Console.WriteLine("\n");

			// Sortowanie i wywietlanie elementw tablicy obiektw klasy Employee
			Console.WriteLine("List<Employee> po sortowaniu:");
			//Employee.EmployeeComparer c = Employee.GetComparer();
			//empList.Sort(c);

			empList.Sort();


			// Wywietlanie caej zawartoci tablicy obiektw klasy Employee
			for (int i = 0; i < empList.Count; i++)
			{
				Console.Write("{0} ", empList[i].ToString());
			}
			Console.WriteLine("\n");

		}
	}
}
